﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using PI.FM.N000.Base.WinForms.Ribbon;
using Gemini.Core.WinForms.Controls.Type;
using Gemini.Core.WinForms.Controls.Interface;
using Gemini.Core.WinForms.Base;


namespace PI.ZB.N1200.ELearning.WinForms.Class
{
    public partial class UCClassDetails : PI.FM.N000.Base.WinForms.Controls.UCBODetails<BL.BO.View.Class, BL.BO.Class.Search>
    {
        private const int _IndexTabInstructor = 0;
        protected     int _IndexTabSystemInformation        = 1;
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private UCTabClassDetails _tabClassDetails = null;

        public UCTabClassDetails TabClassDetails
        {
            get
            {
                if (_tabClassDetails == null)
                {
                    _tabClassDetails = new UCTabClassDetails();
                }
                return _tabClassDetails;
            }
        }

        internal PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        protected int IndexTabSystemInformation
        {
            set
            {
                _IndexTabSystemInformation = value;
            }
            get
            {
                return _IndexTabSystemInformation;
            }
        }

        public UCClassDetails()
        {
            InitializeComponent();

            AddStandardControlTabs();
            MinimumHorizontalSize = 400;
            MinimumVerticalSize = 190;
        }

        protected void AddStandardControlTabs()
        {
            this.AddControlAtTab(_IndexTabInstructor, TabClassDetails, "Ustawienia");
            this.AddControlAtTab(_IndexTabSystemInformation     , TabSystemInformation      , "Informacje systemowe");
        }

        public override void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment ParentEnvironment)
        {
            base.Initialize(ParentPlugIn, ParentEnvironment);

            TabClassDetails.Initialize(this, Environment, ParentPlugIn);
            TabSystemInformation.Initialize(this, Environment, ParentPlugIn);
        }

        protected override Gemini.Core.BL.Base.MethodResult DoSave()
        {
            return new Gemini.Core.BL.Base.MethodResult();
        }

        protected override bool DoRestore(long? ID)
        {
            bool _result = false;
            BL.BO.View.Class _Class = BLZSBELearning.Class.View.RestoreById(ID);
            if (_Class != null)
            {
                _result = true;
                DataManager.LoadData(null, null, _Class);
                TabClassDetails.Restore();
            }

            return _result;
        }

        protected override bool DoConfirmDelete()
        {
            bool _return = false;
            return _return;
        }
    }
}
